﻿using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace VA.PPMS.IWS.MappingService.Data
{
    public class PpmsReference
    {
        [DataMember]
        public IList<PpmsEntityReference> States { get; set; }

        [DataMember]
        public IList<PpmsEntityReference> Specialties { get; set; }

        [DataMember]
        public IList<PpmsEntityReference> VaProviderRelationships { get; set; }
    }

    public class PpmsEntityReference
    {
        [DataMember]
        public Guid Id { get; set; }

        [DataMember]
        public string Value { get; set; }

        public PpmsEntityReference(Guid id, string value)
        {
            Id = id;
            Value = value;
        }

        public EntityReference ToEntityReference(string logicalName)
        {
            return new EntityReference(logicalName, Id);
        }
    }
}
